/**
 * @file    mg32_hwdiv.c
 * @author  MegawinTech Application Team
 * @brief   This file contains all the HWDIV firmware functions 
 */

/* Define to prevent recursive inclusion -----------------------------------------------------------------------------*/
#define _MG32_HWDIV_C_

/* Files includes ----------------------------------------------------------------------------------------------------*/
#include "mg32_hwdiv.h"

/** @addtogroup MG32_StdPeriph_Driver
  * @{
  */

/** @addtogroup HWDIV
  * @{
  */

/** @defgroup HWDIV_Private_Defines
  * @{
  */

/**
  * @}
  */

/** @defgroup HWDIV_Private_Functions
  * @{
  */
/**
  * @brief  Hardware divider unsigned or signed config.
  * @param  usign: Select signed or unsigned.
  * @arg    HWDIV_Signed      Signed division 
  * @arg    HWDIV_UnSigned    Unsigned division 
  * @retval None.
  */
void HWDIV_UsignConfig(uint32_t usign)
{
    MODIFY_REG(HWDIV->CR, HWDIV_CR_USIGN, usign);
}

/**
  * @brief  Hardware divider overflow interrupt enable.
  * @param  state: new state of the Hardware divider.
  *         This parameter can be: ENABLE or DISABLE.
  * @retval None.
  */
void HWDIV_ITConfig(FunctionalState state)
{ 
    (state) ?                                      \
    (HWDIV->CR |=  (0x01U << HWDIV_CR_OVFE_Pos)) : \
    (HWDIV->CR &= ~(0x01U << HWDIV_CR_OVFE_Pos));
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
